#!/bin/bash

USB_AV_ROOT="/sys/kernel/config/usb_gadget/lumens"
resolution=$2
frameRate=$3

function checkResolution()
{
    case $resolution in
    2160P)
	    ;;
    1080P)
	    ;;
    720P)
	    ;;
    *)
            usage
            exit 1
            ;;
    esac
}

function checkFps()
{
    case $frameRate in
    30)
	    ;;
    25)
	    ;;
    *)
            usage
            exit 1
            ;;
    esac
}

function load_Subsystem()
{
    modprobe configfs;
    sudo modprobe libcomposite ;
    sudo modprobe usb_f_uvc;
  #  sudo modprobe u_audio;
  #  sudo modprobe usb_f_uac2;
    sudo modprobe usb_f_hid;
  #  sudo modprobe usb_f_printer;
}

function unload_Subsystem()
{
  #  sudo rmmod usb_f_printer;
    sudo rmmod -f usb_f_hid;
    sudo rmmod -f usb_f_uac2;
    sudo rmmod -f u_audio;
    sudo rmmod -f usb_f_uvc;
    sudo rmmod -f libcomposite ;
    sudo umount /sys/kernel/config; 
    sudo rmmod -f configfs;
}

#////////////////////////////////////////////////////////////////////////////
#                                      HID                                 //
#////////////////////////////////////////////////////////////////////////////
function create_HidFunc()
{
   #modprobe -v usb_f_hid
   #sleep 2;
   mkdir $USB_AV_ROOT/functions/hid.usb0 ;
   
   echo 1 > $USB_AV_ROOT/functions/hid.usb0/protocol ;
   echo 4 > $USB_AV_ROOT/functions/hid.usb0/report_length ;
   echo 2 > $USB_AV_ROOT/functions/hid.usb0/subclass ;

   echo -ne \\x5\\x1\\x9\\x2\\xa1\\x1\\x9\\x1\\xa1\\x0\\x5\\x9\\x19\\x1\\x29\\x3\\x15\\x0\\x25\\x1\\x95\\x3\\x75\\x1\\x81\\x2\\x95\\x1\\x75\\x5\\x81\\x3\\x5\\x1\\x9\\x30\\x9\\x31\\x9\\x38\\x15\\x81\\x25\\x7f\\x75\\x8\\x95\\x3\\x81\\x6\\xc0\\xc0 >  $USB_AV_ROOT/functions/hid.usb0/report_desc

}

function destroy_HidFunc()
{
     rm -rf $USB_AV_ROOT/configs/c.1/hid.usb0;
    rmdir $USB_AV_ROOT/functions/hid.usb0;
}

#////////////////////////////////////////////////////////////////////////////
#                                    Printer                               //
#////////////////////////////////////////////////////////////////////////////
function create_PrinterFunc()
{
   mkdir $USB_AV_ROOT/functions/printer.usb0;
}

function destroy_PrinterFunc()
{
     rm -rf $USB_AV_ROOT/configs/c.1/printer.usb0;
    rmdir $USB_AV_ROOT/functions/printer.usb0;
}


#////////////////////////////////////////////////////////////////////////////
#                                      UAC                                 //
#////////////////////////////////////////////////////////////////////////////
function create_uacFunc()
{
    mkdir $USB_AV_ROOT/functions/uac2.0;
    echo "lumens UAC-2.0" > $USB_AV_ROOT/functions/uac2.0/function_name; 

    echo 0 > $USB_AV_ROOT/functions/uac2.0/c_chmask;
}

function destroy_uacFunc()
{
    rm -rf $USB_AV_ROOT/configs/c.1/uac2.0;
    rmdir $USB_AV_ROOT/functions/uac2.0;
}

#////////////////////////////////////////////////////////////////////////////
#                                      UVC                                 //
#////////////////////////////////////////////////////////////////////////////

function create2160P()
{
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/2160P;
    
    FrameInterval=333333;
    
    case $frameRate in
    30)
        FrameInterval=333333  ;;
    25)
	FrameInterval=400000  ;;
    *)
            usbAV_stop
            exit 1
            ;;
    esac   
    

   # echo 1 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/2160P/bFrameIndex;
    echo 3840 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/2160P/wWidth;
    echo 2160 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/2160P/wHeight;
    echo $FrameInterval > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/2160P/dwFrameInterval;
    echo $FrameInterval > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/2160P/dwDefaultFrameInterval;
    echo 300000000 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/2160P/dwMinBitRate;
    echo 300000000 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/2160P/dwMaxBitRate; 
    
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs;
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/2160P;
   # echo 1 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/2160P/bFrameIndex;
    echo 3840 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/2160P/wWidth;
    echo 2160 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/2160P/wHeight;
    echo $FrameInterval > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/2160P/dwFrameInterval;
    echo $FrameInterval > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/2160P/dwDefaultFrameInterval;
    echo 300000000 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/2160P/dwMinBitRate;
    echo 300000000 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/2160P/dwMaxBitRate;
}

function create1080P()
{
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/1080P;
    
    FrameInterval=333333;
    
    case $frameRate in
    30)
        FrameInterval=333333  ;;
    25)
	FrameInterval=400000  ;;
    *)
            usbAV_stop
            exit 1
            ;;
    esac   
    

   # echo 1 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/1080P/bFrameIndex;
    echo 1920 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/1080P/wWidth;
    echo 1080 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/1080P/wHeight;
    echo $FrameInterval > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/1080P/dwFrameInterval;
    echo $FrameInterval > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/1080P/dwDefaultFrameInterval;
    echo 200000000 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/1080P/dwMinBitRate;
    echo 200000000 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/1080P/dwMaxBitRate; 
    
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs;
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/1080P;
   # echo 1 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/1080P/bFrameIndex;
    echo 1920 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/1080P/wWidth;
    echo 1080 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/1080P/wHeight;
    echo $FrameInterval > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/1080P/dwFrameInterval;
    echo $FrameInterval > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/1080P/dwDefaultFrameInterval;
    echo 200000000 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/1080P/dwMinBitRate;
    echo 200000000 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/1080P/dwMaxBitRate;
}

function create720P()
{
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/720P;
    
    FrameInterval=333333;
    
    case $frameRate in
    30)
        FrameInterval=333333  ;;
    25)
	FrameInterval=400000  ;;
    *)
            usbAV_stop
            exit 1
            ;;
    esac    
    
   # echo 1 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/720P/bFrameIndex;
    echo 1280 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/720P/wWidth;
    echo 720 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/720P/wHeight;
    echo $FrameInterval > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/720P/dwFrameInterval;
    echo $FrameInterval > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/720P/dwDefaultFrameInterval;
    echo 200000000 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/720P/dwMinBitRate;
    echo 200000000 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/720P/dwMaxBitRate; 
    
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs;
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/720P;
   # echo 1 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/720P/bFrameIndex;
    echo 1280 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/720P/wWidth;
    echo 720 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/720P/wHeight;
    echo $FrameInterval > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/720P/dwFrameInterval;
    echo $FrameInterval > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/720P/dwDefaultFrameInterval;
    echo 200000000 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/720P/dwMinBitRate;
    echo 200000000 > $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/720P/dwMaxBitRate;
}

function create_uvcFunc()
{
    #create Video class function    
    mkdir $USB_AV_ROOT/functions/uvc.usb0;
    echo 1 > $USB_AV_ROOT/functions/uvc.usb0/streaming_interval;
    echo 3072 > $USB_AV_ROOT/functions/uvc.usb0/streaming_maxpacket;
    echo 1 > $USB_AV_ROOT/functions/uvc.usb0/streaming_maxburst;
    
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss;
    
    case $resolution in
    2160P)
        create2160P  ;;
    1080P)
        create1080P  ;;
    720P)
	create720P ;;
    *)
            usbAV_stop
            exit 1
            ;;
    esac  
     
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/header/ss;
    ln -s $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss  $USB_AV_ROOT/functions/uvc.usb0/streaming/header/ss;
    ln -s $USB_AV_ROOT/functions/uvc.usb0/streaming/header/ss       $USB_AV_ROOT/functions/uvc.usb0/streaming/class/ss;
    
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/header/hs;
    ln -s $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs  $USB_AV_ROOT/functions/uvc.usb0/streaming/header/hs;
    ln -s $USB_AV_ROOT/functions/uvc.usb0/streaming/header/hs       $USB_AV_ROOT/functions/uvc.usb0/streaming/class/hs;
    
    mkdir $USB_AV_ROOT/functions/uvc.usb0/streaming/header/fs;    
    ln -s $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs  $USB_AV_ROOT/functions/uvc.usb0/streaming/header/fs;
    ln -s $USB_AV_ROOT/functions/uvc.usb0/streaming/header/fs       $USB_AV_ROOT/functions/uvc.usb0/streaming/class/fs;
    
    mkdir $USB_AV_ROOT/functions/uvc.usb0/control/header/h;
    ln -s $USB_AV_ROOT/functions/uvc.usb0/control/header/h    $USB_AV_ROOT/functions/uvc.usb0/control/class/fs;
    ln -s $USB_AV_ROOT/functions/uvc.usb0/control/header/h    $USB_AV_ROOT/functions/uvc.usb0/control/class/ss;
}

function destroy_uvcFunc()
{
    rm -rf $USB_AV_ROOT/configs/c.1/uvc.usb0;
    
    rm -rf  $USB_AV_ROOT/functions/uvc.usb0/control/class/fs/h;
    rm -rf  $USB_AV_ROOT/functions/uvc.usb0/control/class/ss/h; 
    rmdir $USB_AV_ROOT/functions/uvc.usb0/control/header/h;
    rm -rf  $USB_AV_ROOT/functions/uvc.usb0/streaming/class/fs/fs;
    rm -rf  $USB_AV_ROOT/functions/uvc.usb0/streaming/header/fs/mjpeg.hs;
    rmdir   $USB_AV_ROOT/functions/uvc.usb0/streaming/header/fs;
    rm -rf  $USB_AV_ROOT/functions/uvc.usb0/streaming/header/hs/mjpeg.hs;
    rm -rf  $USB_AV_ROOT/functions/uvc.usb0/streaming/class/hs/hs;
    rmdir $USB_AV_ROOT/functions/uvc.usb0/streaming/header/hs; 
    rm -rf $USB_AV_ROOT/functions/uvc.usb0/streaming/header/ss/mjpeg.ss;
    rm -rf $USB_AV_ROOT/functions/uvc.usb0/streaming/class/ss/ss;
    rmdir $USB_AV_ROOT/functions/uvc.usb0/streaming/header/ss;
    rmdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs/$resolution;
    rmdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.hs;
    rmdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss/$resolution;
    rmdir $USB_AV_ROOT/functions/uvc.usb0/streaming/mjpeg/mjpeg.ss;
    rmdir $USB_AV_ROOT/functions/uvc.usb0;
}
#///////////////////////////// UVC end //////////////////////////////////////





#////////////////////////////////////////////////////////////////////////////
#                             configure Descriptor                         //
#////////////////////////////////////////////////////////////////////////////
function create_ConfigureDesc()
{
    #configure description
    mkdir $USB_AV_ROOT/configs/c.1;
    mkdir $USB_AV_ROOT/configs/c.1/strings/0x409;   
    echo "lumensUSBconfig" > $USB_AV_ROOT/configs/c.1/strings/0x409/configuration;
    
    echo 0x80 > $USB_AV_ROOT/configs/c.1/bmAttributes;
    echo 500 > $USB_AV_ROOT/configs/c.1/MaxPower;
}
function link_ConfigureDesc()
{

   ln -s $USB_AV_ROOT/functions/uvc.usb0    $USB_AV_ROOT/configs/c.1;
   ln -s $USB_AV_ROOT/functions/uac2.0      $USB_AV_ROOT/configs/c.1;  
   ln -s $USB_AV_ROOT/functions/hid.usb0    $USB_AV_ROOT/configs/c.1/
   ln -s $USB_AV_ROOT/functions/printer.usb0      $USB_AV_ROOT/configs/c.1;
}

#////////////////////////////////////////////////////////////////////////////
#                               Device Descriptor                          //
#////////////////////////////////////////////////////////////////////////////
function create_usbDevice()
{
    mkdir $USB_AV_ROOT;
    mkdir $USB_AV_ROOT/strings/0x409;
    
    echo 0x1d4d > $USB_AV_ROOT/idVendor;
    echo 0x602b > $USB_AV_ROOT/idProduct; 
    echo 64 > $USB_AV_ROOT/bMaxPacketSize0;
    echo 0xEF > $USB_AV_ROOT/bDeviceClass;
    echo 2 > $USB_AV_ROOT/bDeviceSubClass;
    echo 1 > $USB_AV_ROOT/bDeviceProtocol; 

    echo "lumens" > $USB_AV_ROOT/strings/0x409/manufacturer;
    echo "CamConnect Processor" > $USB_AV_ROOT/strings/0x409/product;
    echo 1234567890 > $USB_AV_ROOT/strings/0x409/serialnumber ;
    echo 1 > $USB_AV_ROOT/os_desc/use;
    echo 0x01 > $USB_AV_ROOT/os_desc/b_vendor_code;
    echo MSFT100 > $USB_AV_ROOT/os_desc/qw_sign;
}
function destroy_usbDevice()
{
    rmdir $USB_AV_ROOT/strings/0x409;
    rmdir $USB_AV_ROOT/configs/c.1/strings/0x409;
    rmdir $USB_AV_ROOT/configs/c.1;
    
    rmdir $USB_AV_ROOT; 
}


function usbAV_start()
{
    checkResolution;
    checkFps;
    
    load_Subsystem;
     
    create_usbDevice;
    
    #video class function
    create_uvcFunc;     
  
    #Audio class function
  #  create_uacFunc;
    
    #HID class function
    create_HidFunc;
    
    #Printer class function
   # create_PrinterFunc;
    
    
    create_ConfigureDesc;
    link_ConfigureDesc;
   
   #mount UDC
   echo "fc000000.usb" > $USB_AV_ROOT/UDC ; 
   sleep 1 ; 
}

function usbAV_stop()
{
    checkResolution;
    
    sudo killall -9 uvc-gadget;
    sleep 0.2;  
    
    echo "" > $USB_AV_ROOT/UDC ;
    sleep 1; 
    
    #remove Printer
  #  destroy_PrinterFunc;
     
    #remove HID
    destroy_HidFunc;
    
    #remove UAC
  #  destroy_uacFunc
    
    #remove UVC
    destroy_uvcFunc
  
    #remove strings configs devices descriptor
    destroy_usbDevice
   
    #remove linux subsystem
    unload_Subsystem
}

usage()
{
    echo "Usage: ./usbAV.sh {start} { 1080P|720P } { 30|25 } "
    echo "Usage: ./usbAV.sh {stop} { 1080P|720P }"
}

case $1 in
start)
	usbAV_start
	;;
stop)
	usbAV_stop
	;;
*)
	usage
	exit 1
	;;
esac

exit 0
